/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/sales_orders/print_out/',
        urlList: window.APP.siteUrl + 'adm/sales_returns/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/sales_returns/get_data_detail',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
				},
				methods: {
					detailAdd: function () {
						// show modal
						var customer = $("#customer-select").val();

						if(customer == ""){
							toastr.warning('Silahkan pilih pelanggan terlebih dahulu!')
						}else{
							$(that.elModal).modal("show");
							$.ajax({
								url: that.urlList,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
						}
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								ii.prop('checked', false);

							}, 100);
						}
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();
                    	var trx_id = $("#trx_id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id,
                    			'trx_id': trx_id,
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},

					handleNumber: function () {
						var vue = this;

						$("#customer-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/sales_returns/get_number',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
									// $("#id").val(data['id']);
									// $("#retur_number").val(data['retur_number']);
									$("#so-select").html("<option value=''>- Pilih -</option>");
									$.each(data['so_data'], function(i, d) {
										if (id===d.sales_order_header_id) {
												$('#so-select').append('<option value="' + d.sales_order_header_id + '" selected="selected">' + d.sales_order_header_number + '</option>');
											}else{
												$('#so-select').append('<option value="' + d.sales_order_header_id + '">' + d.sales_order_header_number + '</option>');
											}
									});									
								},
							});			
						});
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);
						vue.handleCount(row, field_name, value);
					},
					
					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
							vue.handleStock(row, field_name, value);
						}

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));
						vue.$set(row, 'total', total.toLocaleString("en-US"));
						// discount = total * row.discount / 100;
						// sub_total = total - discount;
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));
						// vue.$set(row, field_name, value);
					},

					handleStock: function(row, field_name, value) {
						var vue = this;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Retur melebihi stok!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
						}
						
						vue.$set(row, 'total_stock', calc);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							var total = parseFloat(items[i].total);
							if(total > 0){
								total = parseFloat(items[i].total.replace(/,/g, ''));
							}
							totalAmmount += total;
						}

						return totalAmmount.toLocaleString("en-US");
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
					vue.handleData();
					vue.handleNumber();
					
					setTimeout(function () {
						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
					}, 500);
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();
			
			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						setTimeout(function () {
							window.location.href = window.APP.siteUrl + 'adm/sales_returns/';
						}, 1500);
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);