<?php
/**
 * Imports Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Imports extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Stocks_model');
		$this->load->model('Logs_model');
		$this->load->model('Items_model');
		$this->load->model('Units_model');
		$this->load->model('Groups_model');
		$this->load->model('Group_customers_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Customers_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Group_prices_model');
	}
	
	public function index() {
		$data['content_title'] = 'Import Data';

		$data['msg_unit']      = $this->session->userdata('msg_unit');
		$data['msg_group']     = $this->session->userdata('msg_group');
		$data['msg_item']      = $this->session->userdata('msg_item');
		$data['msg_img_item']  = $this->session->userdata('msg_img_item');
		$data['msg_wholesale'] = $this->session->userdata('msg_wholesale');
		$data['msg_supplier']  = $this->session->userdata('msg_supplier');
		$data['msg_customer']  = $this->session->userdata('msg_customer');
		$data['msg_special']   = $this->session->userdata('msg_special');
		$data['msg_group_customer']   = $this->session->userdata('msg_group_customer');
		$data['msg_group_price']   = $this->session->userdata('msg_group_price');

		$this->twiggy_display('adm/imports/index', $data);
		$this->session->unset_userdata('msg_unit');
		$this->session->unset_userdata('msg_group');
		$this->session->unset_userdata('msg_item');
		$this->session->unset_userdata('msg_img_item');
		$this->session->unset_userdata('msg_wholesale');
		$this->session->unset_userdata('msg_supplier');
		$this->session->unset_userdata('msg_customer');
		$this->session->unset_userdata('msg_special');
		$this->session->unset_userdata('msg_group_customer');
		$this->session->unset_userdata('msg_group_price');
	}

	public function import_units() {
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("unit_name" => $rowData[0][0]);
			$exist = $this->Units_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"unit_name" => $rowData[0][0],
					"unit_priority" => $rowData[0][1],
				];
				$insert = $this->db->insert("master_units", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_groups() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			// Start Save Group
			$where = array("group_name" => $rowData[0][1]);
			$exist = $this->Groups_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"group_name" => $rowData[0][1],
					"group_order" => $rowData[0][2]
				];
				$insert = $this->db->insert("master_groups", $data);
			}
			// End

			//Start Save Sub Group
			$group_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
			$group_id   = 0;
			if($group_name != ""){
				$where_group    = array("group_name" => $group_name);
				$get_data_group = $this->Groups_model->get_data($where_group)->row();
				if($get_data_group){
					$group_id = $get_data_group->group_id;
				}
			}

			$where_2 = array("group_child_name" => $rowData[0][0], "a.group_id" => $group_id);
			$exist_2 = $this->Groups_model->get_data_child($where_2)->row();

			if($exist_2 == null){
				$data_2 = [
					"group_child_name" => $rowData[0][0],
					"group_id"         => $group_id
				];
				$insert_2 = $this->db->insert("master_group_childs", $data_2);
			}
			// End
		}

		unlink($inputFileName);

		$msg = '';
		if($insert_2){
			$msg = true;
			$this->session->set_userdata('msg_group', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_group_customers() {
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("group_customer_name" => $rowData[0][0]);
			$exist = $this->Group_customers_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"group_customer_name" => $rowData[0][0]
				];
				$insert = $this->db->insert("master_group_customers", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_group_customer', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_items() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$prefix           = "STO";
		$datenow          = date('Ym');
		$number_generator = $this->Stocks_model->stock_autonumber();
		$autonumber       = $prefix.$datenow.$number_generator;

		$header_data = [
			'stock_header_number'         => $autonumber,
			'stock_header_date'           => date_now(),
			'stock_header_payment_due'    => date_now(),
			'stock_header_supplier_id'    => 0,
			'stock_header_sub_total'      => 0,
			'stock_header_ppn_id'         => 0,
			'stock_header_ppn_percentage' => 0,
			'stock_header_ppn_total'      => 0,
			'stock_header_grand_total'    => 0,
			'stock_header_description'    => '',
		];

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("item_name" => $rowData[0][0]);
				$exist = $this->Items_model->get_data($where)->row();

				if($exist == null){

					// Sesuaikan key array dengan nama kolom di database
					$group_name       = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
					$group_child_name = ($rowData[0][2]  == NULL ? "" : $rowData[0][2]);
					if($group_name != ""){
						$where_group    = array("group_name" => $group_name);
						$get_data_group = $this->Groups_model->get_data($where_group)->row();
						if($get_data_group){
							$group_name = $get_data_group->group_id;
						}
					}

					if($group_child_name != ""){
						$where_group_child    = array("group_child_name" => $group_child_name);
						$get_data_group_child = $this->Groups_model->get_data_child($where_group_child)->row();
						if($get_data_group_child){
							$group_child_name = $get_data_group_child->group_child_id;
						}
					}


					$data = [
						"item_name"                       => $rowData[0][0],
						"item_group_id"                   => $group_name,
						"item_group_child_id"             => $group_child_name,
						"large_unit"                      => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
						"large_unit_contain"              => ($rowData[0][4]  == NULL ? 0 : $rowData[0][4]),
						"medium_unit"                     => ($rowData[0][5]  == NULL ? "" : $rowData[0][5]),
						"medium_unit_contain"             => ($rowData[0][6]  == NULL ? 0 : $rowData[0][6]),
						"small_unit"                      => ($rowData[0][7]  == NULL ? "" : $rowData[0][7]),
						"small_unit_contain"              => ($rowData[0][8]  == NULL ? 0 : $rowData[0][8]),
						"last_purchase_price_large_unit"  => ($rowData[0][9]  == NULL ? 0 : $rowData[0][9]),
						"last_purchase_price_medium_unit" => ($rowData[0][10] == NULL ? 0 : $rowData[0][10]),
						"last_purchase_price_small_unit"  => ($rowData[0][11] == NULL ? 0 : $rowData[0][11]),
						"last_selling_price_large_unit"   => ($rowData[0][12] == NULL ? 0 : $rowData[0][12]),
						"last_selling_price_medium_unit"  => ($rowData[0][13] == NULL ? 0 : $rowData[0][13]),
						"last_selling_price_small_unit"   => ($rowData[0][14] == NULL ? 0 : $rowData[0][14]),
						"minimum_stock"                   => ($rowData[0][15] == NULL ? 0 : $rowData[0][15]),
						"ppn_status"                      => ($rowData[0][16] == NULL ? 0 : $rowData[0][16]),
						"img_filename"                    => ($rowData[0][17] == NULL ? "default.jpg" : $rowData[0][17])
					];
					$insert = $this->db->insert("master_items", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_image_items() {
		if(!empty($_FILES['image_name']['name'])){
	    	$ImageCount = count($_FILES['image_name']['name']);

	        for($i = 0; $i < $ImageCount; $i++){
	            $_FILES['file']['name']       = $_FILES['image_name']['name'][$i];
	            $_FILES['file']['type']       = $_FILES['image_name']['type'][$i];
	            $_FILES['file']['tmp_name']   = $_FILES['image_name']['tmp_name'][$i];
	            $_FILES['file']['error']      = $_FILES['image_name']['error'][$i];
	            $_FILES['file']['size']       = $_FILES['image_name']['size'][$i];

	            // File upload configuration
	            $uploadPath = './assets/images/upload_file/items/';
	            $config['upload_path'] = $uploadPath;
	            $config['allowed_types'] = 'jpg|jpeg|png';

	            // Load and initialize upload library
	            $this->load->library('upload', $config);
	            $this->upload->initialize($config);

	            // Upload file to server
	            if($this->upload->do_upload('file')){
	                $imageData = $this->upload->data();
	                $uploadImgData[$i]['image_name'] = $imageData['file_name'];
	            }
			}
			
			$msg2 = true;
			$this->session->set_userdata('msg_img_item', $msg2);

        	redirect('adm/imports/');
		}
	}

	public function import_wholesale_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$item_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"item_id"       => $item_id,
					"minimum_order" => $rowData[0][1],
					"maximum_order" => $rowData[0][2],
					"price"         => $rowData[0][3],
					"is_active"     => 1,
				);

			$insert = $this->db->insert("master_wholesale_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_wholesale', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_suppliers() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("supplier_code" => $rowData[0][0]);
			$exist = $this->Suppliers_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"supplier_code"         => $rowData[0][0],
					"supplier_name"         => $rowData[0][1],
					"supplier_telephone"    => $rowData[0][2],
					"supplier_address"      => $rowData[0][3],
					"supplier_payment_term" => $rowData[0][4]
				];
				$insert = $this->db->insert("master_suppliers", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_supplier', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_customers() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);

			$group_customer       = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
			if($group_customer != ""){
				$where_group    = array("group_customer_name" => $group_customer);
				$get_data_group = $this->Group_customers_model->get_data($where_group)->row();
				if($get_data_group){
					$group_customer = $get_data_group->group_customer_id;
				}
			}

			if($this->isEmptyRow(reset($rowData))) { continue; }

			$data = [
				"customer_name"         => $rowData[0][0],
				"group_customer_id"     => $group_customer,
				"customer_ktp"          => $rowData[0][2],
				"customer_npwp"         => $rowData[0][3],
				"customer_telephone"    => $rowData[0][4],
				"customer_address"      => $rowData[0][5],
				"customer_payment_term" => $rowData[0][6],
				"customer_username"     => $rowData[0][7],
				"customer_password"     => $rowData[0][8],
				"customer_pin"          => $rowData[0][9]
			];
			$insert = $this->db->insert("master_customers", $data);
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_customer', $msg);
		}
		
        redirect('adm/imports/');
	}

	function isEmptyRow($row) {
		foreach($row as $cell){
			if (null !== $cell) return false;
		}
		return true;
	}

	public function import_special_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$customer_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$customer_id    = 0;
				if($customer_name != ""){
					$where    = array("customer_name" => $customer_name);
					$get_data = $this->Customers_model->get_data($where)->row();
					if($get_data){
						$customer_id = $get_data->customer_id;
					}
				}

				$item_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"customer_id" => $customer_id,
					"item_id"     => $item_id,
					"large_unit"  => $rowData[0][2],
					"price"       => $rowData[0][3],
					"is_active"   => 1,
				);

			$insert = $this->db->insert("master_special_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_special', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_group_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$group_customer_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$group_customer_id    = 0;
				if($group_customer_name != ""){
					$where    = array("group_customer_name" => $group_customer_name);
					$get_data = $this->Group_customers_model->get_data($where)->row();
					if($get_data){
						$group_customer_id = $get_data->group_customer_id;
					}
				}

				$item_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"group_customer_id" => $group_customer_id,
					"item_id"     => $item_id,
					"price"       => $rowData[0][2],
					"is_active"   => 1,
				);

			$insert = $this->db->insert("master_group_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_group_price', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function export_units() {
		
		$get_data = $this->Units_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("SATUAN")
							   ->setSubject("SATUAN")
							   ->setDescription("SATUAN")
							   ->setKeywords("SATUAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA SATUAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "URUTAN");
	    $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->unit_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->unit_priority);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("SATUAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel

		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'SATUAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_groups() {
		
		$get_data = $this->Groups_model->get_data_child()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("GRUP")
							   ->setSubject("GRUP")
							   ->setDescription("GRUP")
							   ->setKeywords("GRUP");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA SUB GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "ORDER GRUP");
	    $excel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_child_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->group_order);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("GRUP");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'GRUP_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_group_customers() {
		
		$get_data = $this->Group_customers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("GRUP PELANGGAN")
							   ->setSubject("GRUP PELANGGAN")
							   ->setDescription("GRUP PELANGGAN")
							   ->setKeywords("GRUP PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA GRUP PELANGGAN");
	    $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_customer_name);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("GRUP PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'GRUP_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_items() {
		
		$get_data = $this->Items_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("BARANG")
							   ->setSubject("BARANG")
							   ->setDescription("BARANG")
							   ->setKeywords("BARANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "SUB GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "SATUAN BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "ISI BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "SATUAN SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "ISI SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "SATUAN KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "ISI KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('J1', "HARGA BELI BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('K1', "HARGA BELI SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('L1', "HARGA BELI KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('M1', "HARGA JUAL BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('N1', "HARGA JUAL SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('O1', "HARGA JUAL KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('P1', "MINIMUM STOK");
	    $excel->setActiveSheetIndex(0)->setCellValue('Q1', "STATUS PPN");
	    $excel->setActiveSheetIndex(0)->setCellValue('R1', "NAMA FILE GAMBAR");
	    $excel->getActiveSheet()->getStyle('A1:R1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->group_child_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->large_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->medium_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->small_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->last_purchase_price_large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $get_row->last_purchase_price_medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, $get_row->last_purchase_price_small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $get_row->last_selling_price_large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, $get_row->last_selling_price_medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, $get_row->last_selling_price_small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, $get_row->minimum_stock);
			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, $get_row->ppn_status);
			$excel->setActiveSheetIndex(0)->setCellValue('R'.$numrow, $get_row->img_filename);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("BARANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'BARANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_wholesale_prices() {
		
		$get_data = $this->Wholesale_prices_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA GROSIR")
							   ->setSubject("HARGA GROSIR")
							   ->setDescription("HARGA GROSIR")
							   ->setKeywords("HARGA GROSIR");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "MINIMUM ORDER");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "MAKSIMAL ORDER");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->minimum_order);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->maximum_order);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA GROSIR");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_GROSIR_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_suppliers() {
		
		$get_data = $this->Suppliers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("SUPPLIER")
							   ->setSubject("SUPPLIER")
							   ->setDescription("SUPPLIER")
							   ->setKeywords("SUPPLIER");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "KODE");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA SUPPLIER");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "TELEPON");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "ALAMAT");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "JANGKA WAKTU PEMBAYARAN");
	    $excel->getActiveSheet()->getStyle('A1:E1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->supplier_code);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->supplier_telephone);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->supplier_address);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->supplier_payment_term);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("SUPPLIER");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'SUPPLIER_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_customers() {
		
		$get_data = $this->Customers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PELANGGAN")
							   ->setSubject("PELANGGAN")
							   ->setDescription("PELANGGAN")
							   ->setKeywords("PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "GRUP PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "KTP");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "NPWP");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "TELEPON");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "ALAMAT");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "JANGKA WAKTU PEMBAYARAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "USERNAME");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "PASSWORD");
	    $excel->setActiveSheetIndex(0)->setCellValue('J1', "PIN");
	    $excel->getActiveSheet()->getStyle('A1:J1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_ktp);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->customer_npwp);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->customer_telephone);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->customer_address);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->customer_payment_term);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->customer_username);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->customer_password);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->customer_pin);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_special_prices() {
		
		$get_data = $this->Special_prices_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA PELANGGAN")
							   ->setSubject("HARGA PELANGGAN")
							   ->setDescription("HARGA PELANGGAN")
							   ->setKeywords("HARGA PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "SATUAN BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_group_prices() {
		
		$get_data = $this->Group_prices_model->get_data_group_price()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA GRUP PELANGGAN")
							   ->setSubject("HARGA GRUP PELANGGAN")
							   ->setDescription("HARGA GRUP PELANGGAN")
							   ->setKeywords("HARGA GRUP PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA GRUP PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA GRUP PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_GRUP_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
