<?php
/**
 * Items Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Items extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		$this->load->model('Wholesale_prices_model');
	}
	
	public function index() {
		$data['content_title'] = 'Barang';

		$this->twiggy_display('adm/items/index', $data);

	}

	public function get_data() {
		$data = [];
		$get_data = $this->Items_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {
				$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
				$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
				$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

				$unit = rtrim($get_row->large_unit." ".$lg_unit.", ".$get_row->medium_unit." ".$md_unit.", ".$get_row->small_unit." ".$sm_unit, ", ");
				$ppn_status = '-';
				if($get_row->ppn_status == '2'){
					$ppn_status = "<span class='badge badge-success' style='width:100px;'>2</span>";
				}elseif($get_row->ppn_status == '1'){
					$ppn_status = "<span class='badge badge-secondary' style='width:100px;'>1</span>";
				}else{
					$ppn_status = "<span class='badge badge-warning' style='width:100px;'>3</span>";
				}

				$minimum_stock = "<span class='badge badge-danger' style='width:100px;'>".to_decimal($get_row->minimum_stock) ." ". $get_row->large_unit."</span>";
				$bgcolor = ($get_row->mobile_active == "1" ? "bg-info" : "");

				$data[] = array(
					'no'            => $no,
					'id'            => $get_row->item_id,
					'name'          => $get_row->item_name,
					'grup'          => $get_row->group_name,
					'grup_child'    => $get_row->group_child_name,
					'unit'          => $unit,
					'minimum_stock' => $minimum_stock,
					'ppn_status'    => $ppn_status,
					'mobile_active' => $get_row->mobile_active,
					'bgcolor'       => $bgcolor
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_data_group_child()
	{
		$id = $this->input->post('id');

		$where  = array('a.group_id' => $id);
		$result = $this->Groups_model->get_data_child($where)->result();
		
		echo json_encode($result);
	}

	public function edit($id='new') {
		$title       = "Tambah";
		$get_data    = array();
		$minimum_stock  = 0;
		$lg_contain  = 0;
		$lg_selling  = 0;
		$lg_purchase = 0;
		$md_contain  = 0;
		$md_selling  = 0;
		$md_purchase = 0;
		$sm_contain  = 0;
		$sm_selling  = 0;
		$sm_purchase = 0;
		$img_file    = 'default.jpg';

		if($id != 'new') {
			$title    = "Edit";
			$where         = array('item_id' => $id);
			$get_data      = $this->Items_model->get_data($where)->row_array();
			$minimum_stock = to_decimal(check_array_key($get_data, 'minimum_stock'));
			$lg_contain    = to_decimal(check_array_key($get_data, 'large_unit_contain'));
			$lg_purchase   = number_format(check_array_key($get_data, 'last_purchase_price_large_unit'));
			$lg_selling    = number_format(check_array_key($get_data, 'last_selling_price_large_unit'));
			$md_contain    = to_decimal(check_array_key($get_data, 'medium_unit_contain'));
			$md_purchase   = number_format(check_array_key($get_data, 'last_purchase_price_medium_unit'));
			$md_selling    = number_format(check_array_key($get_data, 'last_selling_price_medium_unit'));
			$sm_contain    = to_decimal(check_array_key($get_data, 'small_unit_contain'));
			$sm_purchase   = number_format(check_array_key($get_data, 'last_purchase_price_small_unit'));
			$sm_selling    = number_format(check_array_key($get_data, 'last_selling_price_small_unit'));
			$img_file      = check_array_key($get_data, 'img_filename');
		}

		$data['id']               = $id;
		$data['content_title']    = $title;
		$data['get_data']         = $get_data;
		$data['group_data']       = $this->Groups_model->get_data()->result();
		$data['group_child_data'] = $this->Groups_model->get_data_child()->result();
		$data['unit_data']        = $this->Units_model->get_data()->result();

		$data['minimum_stock'] 	= $minimum_stock;
		$data['lg_contain'] 	= $lg_contain;
		$data['lg_purchase'] 	= $lg_purchase;
		$data['lg_selling'] 	= $lg_selling;
		$data['md_contain'] 	= $md_contain;
		$data['md_purchase'] 	= $md_purchase;
		$data['md_selling'] 	= $md_selling;
		$data['sm_contain'] 	= $sm_contain;
		$data['sm_purchase'] 	= $sm_purchase;
		$data['sm_selling'] 	= $sm_selling;

		$data['img_file_name'] 	= $img_file;
		$data['img_file_dir'] 	= base_url('assets/images/upload_file/items/') .$img_file;

		$this->twiggy_display('adm/items/edit', $data);
	}

	public function edit_range($id='new') {
		$title    = "Tambah";
		// $get_data = array();

		// if($id != 'new') {
		// 	$title    = "Edit";
		// 	$where = array('item_id' => $id);
		// 	$get_data = $this->Items_model->get_data($where)->row_array();
		// }

		// $data['id']            = $id;
		$data['content_title'] = $title;
		// $data['get_data']      = $get_data;
		// $data['group_data'] 	    = $this->Groups_model->get_data()->result();
		// $data['group_child_data'] 	= $this->Groups_model->get_data_child()->result();
		// $data['unit_data'] 	= $this->Units_model->get_data()->result();

		$this->twiggy_display('adm/items/edit_range', $data);
	}

	public function save() {
		// post
		$id                              = $this->input->post('id');
		$name                            = $this->input->post('name');
		$minimum_stock                   = $this->input->post('minimum_stock');
		$group                           = $this->input->post('group');
		$group_child                     = $this->input->post('group_child');
		$large_unit                      = $this->input->post('large_unit');
		$large_unit_contain              = $this->input->post('large_unit_contain');
		$last_purchase_price_large_unit  = $this->input->post('last_purchase_price_large_unit');
		$last_selling_price_large_unit   = $this->input->post('last_selling_price_large_unit');
		$medium_unit                     = $this->input->post('medium_unit');
		$medium_unit_contain             = $this->input->post('medium_unit_contain');
		$last_purchase_price_medium_unit = $this->input->post('last_purchase_price_medium_unit');
		$last_selling_price_medium_unit  = $this->input->post('last_selling_price_medium_unit');
		$small_unit                      = $this->input->post('small_unit');
		$small_unit_contain              = $this->input->post('small_unit_contain');
		$last_purchase_price_small_unit  = $this->input->post('last_purchase_price_small_unit');
		$last_selling_price_small_unit   = $this->input->post('last_selling_price_small_unit');
		$ppn_status                      = $this->input->post('ppn_status');

		$old_img                         = $this->input->post('old_img');

		$action                          = $this->input->post('action');
		
		
		$path = './assets/images/upload_file/items/';
		$item_picture_name = 'item_picture_name';
		$filename = 'default.jpg';
		$allowedTypes = 'jpg|jpeg|png';

		if(!empty($_FILES['item_picture_name']['name'])){
			$filename = $_FILES['item_picture_name']['name'];
			upload_file($path, $item_picture_name, null, $allowedTypes);
		}

		if($filename == 'default.jpg' && !empty($old_img)){
			$filename = $old_img;
		}

		if(isset($medium_unit) && $medium_unit != "" && $medium_unit_contain > 0 && $last_purchase_price_large_unit > 0){
			$last_purchase_price_medium_unit = (trims($last_purchase_price_large_unit)/trims($large_unit_contain));
		}

		if(isset($small_unit) && $small_unit != "" && $small_unit_contain > 0 && $last_purchase_price_small_unit > 0){
			$last_purchase_price_small_unit = (trims($last_purchase_price_medium_unit)/trims($medium_unit_contain));
		}

		$data_save = array(
			'item_name'                       => $name,
			'minimum_stock'                   => $minimum_stock,
			'item_group_id'                   => $group,
			'item_group_child_id'             => $group_child,
			'large_unit'                      => $large_unit,
			'large_unit_contain'              => $large_unit_contain,
			'last_purchase_price_large_unit'  => trims($last_purchase_price_large_unit),
			'last_selling_price_large_unit'   => trims($last_selling_price_large_unit),
			'medium_unit'                     => $medium_unit,
			'medium_unit_contain'             => $medium_unit_contain,
			'last_purchase_price_medium_unit' => trims($last_purchase_price_medium_unit),
			'last_selling_price_medium_unit'  => trims($last_selling_price_medium_unit),
			'small_unit'                      => $small_unit,
			'small_unit_contain'              => $small_unit_contain,
			'last_purchase_price_small_unit'  => trims($last_purchase_price_small_unit),
			'last_selling_price_small_unit'   => trims($last_selling_price_small_unit),
			'ppn_status'                      => $ppn_status,
			'img_filename'                    => str_replace(" ", "_", $filename)
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Items_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Items_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function save_grouping_quantity()
	{	
		$id         = $this->input->post('id');
		$number     = $this->input->post("number");
		$date       = $this->input->post("date");
		$supplier   = $this->input->post("supplier");
		$description  = $this->input->post("description");
		
		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;
		
		echo json_encode($vuedata);
		$response = [
			'message' => 'success',
			'status'  => 'success',
			'id'      => 'success'
		];
		output_json($response);
		die();
		$header_data = [
			'purchase_order_header_number'        => $number,
			'purchase_order_header_date'          => change_format_date($date),
			'purchase_order_header_supplier_id'   => $supplier,
			'purchase_order_header_description'   => $description
		];

		$detail_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Purchase_orders_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'purchase_order_detail_header_id'      => $header_id,
						'purchase_order_detail_material_id'    => $row['id'],
						'purchase_order_detail_material_name'  => $row['name'],
						'purchase_order_detail_unit_id'        => $row['unit_id'],
						'purchase_order_detail_quantity'       => $row['quantity'],
						'purchase_order_detail_remark'         => $row['remark'],
					];
				}
				
				$save_detail = $this->Purchase_orders_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
				
			$delete_detail = $this->Purchase_orders_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Purchase_orders_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'purchase_order_detail_header_id'      => $header_id,
							'purchase_order_detail_material_id'    => $row['id'],
							'purchase_order_detail_material_name'  => $row['name'],
							'purchase_order_detail_unit_id'        => $row['unit_id'],
							'purchase_order_detail_quantity'       => $row['quantity'],
							'purchase_order_detail_remark'         => $row['remark'],
						];
					}

					$save_detail = $this->Purchase_orders_model->save_detail($detail_data, true);
					
					if($save_detail)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}

			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}


	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Items_model->delete($row);
			$delete_type_detail = $this->Wholesale_prices_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function show_item_on_mobile() {
		$id = $this->input->post('id');
		$data = $this->input->post('data');

		$is_active = ($data == "0" ? "1" : "0");
		$msg = ($data == "0" ? "Berhasil menampilkan barang pada Mobile Apps" : "Berhasil menyembunyikan barang dari Mobile Apps");
		$data = array(
			'mobile_active' => $is_active,
		);
		$update = $this->Items_model->update($id, $data);

		$response = array(
			'message' => $msg,
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$username  = $this->input->post('id');
		$where     = array('item_name' => $username);

		$check = $this->Items_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
