<?php
/**
 * Point Redeems Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Ptsredeems extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Ptsredeems_model');
		$this->load->model('Customers_model');
		$this->load->model('Log_points_model');
	}
	
	public function index() {
		$data['content_title'] = 'Tukar Poin';
		$data['customer_data'] = $this->Customers_model->get_data()->result();

		$this->twiggy_display('adm/ptsredeems/index', $data);
	}

	public function get_data() {
		$data     = [];
		$customer = $this->input->post('customer_id');

		$where    = array('ptsredeem_customer_id' => $customer);
		$get_data = $this->Ptsredeems_model->get_data($where)->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->ptsredeem_id,
					'number'      => $get_row->ptsredeem_number,
					'date'        => indonesian_date($get_row->ptsredeem_date),
					'customer'    => $get_row->customer_name,
					'total_point' => $get_row->ptsredeem_total,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_customerpoint()
	{	
		$id          = $this->input->post('customer_id');
		$where       = array("log_point_customer_id" => $id);
		$point_total = 0;

		$get_data_log = $this->Log_points_model->get_data_last($where)->row();
		if($get_data_log){
			$point_total = $get_data_log->log_point_total;
		}

		echo json_encode($point_total);
	}

	public function edit($id='new', $customer_id='') {
		$title       = "Tukar Poin";
		$get_data    = array();

		$where       = array("log_point_customer_id" => $customer_id);
		$point_total = 0;
		$point_last = 0;
		$get_data_log = $this->Log_points_model->get_data_last($where)->row();
		if($get_data_log){
			$point_total = $get_data_log->log_point_total;
		}

		if($id != 'new') {
			$title    = "Tukar Poin";
			$where_data = array('ptsredeem_id' => $id);
			$get_data = $this->Ptsredeems_model->get_data($where_data)->row_array();
			
			if($get_data_log){
				$point_last = $get_data_log->log_point_total;
			}
			$point_total = ($point_last + $get_data['ptsredeem_total']);
		}

		$data['id']            = $id;
		$data['customer_id']   = $customer_id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['point_total']   = $point_total;

		$this->twiggy_display('adm/ptsredeems/edit', $data);
	}

	public function save() {
		// post
		$id               = $this->input->post('id');
		$customer         = $this->input->post('customer_id');
		$point_redeem     = $this->input->post('point_redeem');
		$prefix           = "RD";
		$datenow          = date('mY');
		$number_generator = $this->Ptsredeems_model->redeem_autonumber();
		$autonumber = $prefix.$datenow.$number_generator;
		
		$action    = $this->input->post('action');

		$data_save = array(
			'ptsredeem_number'      => $autonumber,
			'ptsredeem_date'        => date_now(),
			'ptsredeem_customer_id' => $customer,
			'ptsredeem_total'       => $point_redeem,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Ptsredeems_model->save($data_save);
			if($save){
				$header_id  = $this->db->insert_id();
				$s_trx      = 'new';
				$checkpoint = $this->checkpoint($s_trx, $header_id, $datenow, $customer, $point_redeem);
			}
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Ptsredeems_model->update($id, $data_save);
			if($save){
				$s_trx      = 'update';
				$checkpoint = $this->checkpoint($s_trx, $id, $datenow, $customer, $point_redeem);
			}
		}

		if($checkpoint) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function checkpoint($s_trx, $transaction_id, $transaction_date='', $customer_id='', $ttl_pts='')
	{
		if($s_trx == 'new'){

			$where       = array('log_point_customer_id' => $customer_id);
			$log_data    = $this->Log_points_model->get_data_last($where)->row_array();
			$point_total = 0;
			$last_point_total  = 0;

			if(!empty($log_data)){
				$last_point_total = $log_data['log_point_total'];
			}

			$point_total = ($last_point_total - $ttl_pts);
			$header_data = [
				'log_point_type'           => 'RD',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => -abs($ttl_pts),
				'log_point_total'          => $point_total,
			];

			$save_header = $this->Log_points_model->save($header_data);

		}

		if($s_trx == 'update'){
			
			$where_1          = array('log_point_type' => 'RD', 'log_point_transaction_id' => $transaction_id, 'log_point_customer_id' => $customer_id);
			$log_point_id     = $this->Log_points_model->get_data($where_1)->row()->log_point_id;
			$where_2          = array('log_point_customer_id' => $customer_id, 'log_point_id <' => $log_point_id);
			$log_data_before  = $this->Log_points_model->get_data_last($where_2)->row_array();
			$point_total      = 0;
			$last_point_total = 0;

			if(!empty($log_data_before)){
				$last_point_total = $log_data_before['log_point_total'];
			}

			$point_total = ($last_point_total - $ttl_pts);
			$header_data = [
				'log_point_type'           => 'RD',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => -abs($ttl_pts),
				'log_point_total'          => $point_total,
			];
			
			$update_item  = $this->Log_points_model->update($where_1, $header_data);

			if($update_item){
				$where_3 = array('log_point_customer_id' => $customer_id, 'log_point_id >' => $log_point_id);
				$get_data_all_logs_by_customer = $this->Log_points_model->get_data($where_3)->result();

				if($get_data_all_logs_by_customer){
					foreach ($get_data_all_logs_by_customer as $row) {

						$where_3              = array('log_point_customer_id' => $row->log_point_customer_id, 'log_point_id <' => $row->log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);

					}
				}else{
					return true;
				}
			}else{
				$save_header = false;
			}

		}

		if($s_trx == 'delete'){
			$save_header = false;
			$where = array('log_point_type' => 'RD', 'log_point_transaction_id' => $transaction_id);
			$get_data_log = $this->Log_points_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {
				
				$where_after = array('log_point_customer_id' => $row_list->log_point_customer_id, 'log_point_id >' => $row_list->log_point_id);
				$get_after   = $this->Log_points_model->get_data($where_after)->result();

				if($get_after){

					foreach ($get_after as $row_list_detail) {
						
						$where_delete = array('log_point_id' => $row_list->log_point_id);
						$delete  = $this->Log_points_model->delete($where_delete);

						$where_this   = array('log_point_id' => $row_list_detail->log_point_id, 'log_point_customer_id' => $row_list_detail->log_point_customer_id);
						$log_point_id = $this->Log_points_model->get_data($where_this)->row()->log_point_id;
						
						$where_3              = array('log_point_customer_id' => $row_list_detail->log_point_customer_id, 'log_point_id <' => $log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row_list_detail->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row_list_detail->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);
					}
					
				}else{
					$where_delete = array('log_point_id' => $row_list->log_point_id);
					$save_header  = $this->Log_points_model->delete($where_delete);
				}
			}

		}
		
		if($save_header){
			return true;
		}else{
			return false;
		}
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Ptsredeems_model->delete($row);
			if($delete_type){
				$s_trx      = 'delete';
				$checkpoint = $this->checkpoint($s_trx, $row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
