<?php
/**
 * Report Requiremetns Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Rep_requirements extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');

		$this->load->model('Batches_model');
		$this->load->model('Programs_model');
		$this->load->model('Trainees_model');
		$this->load->model('Companies_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Persyaratan';
         
 		// $data['batch_data']   = $this->Batches_model->batch_header()->result();
 		// $data['program_data'] = $this->Programs_model->program_header()->result();
 		// $data['trainee_data'] = $this->Trainees_model->get_data()->result();
		// $data['company_data'] = $this->Companies_model->get_data()->result();

		$data['programcode_data']   = $this->Reports_model->get_reqcode_select()->result();
		
		if(check_roles('1') or check_roles('3')){
			$this->twiggy_display('adm/rep_requirements/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_detail()
	{	
		$program  = $this->input->post("program");
		$status  = $this->input->post("status");

		$data = [];
		$get_data = $this->Reports_model->get_requirements_detail($status, $program)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$info   = ($status == 1 ? "Peserta telah menyelesaikan syarat ini" : "Peserta belum menyelesaikan syarat ini");

				$data[] = array(
					'no'          => $no,
					'code'        => $get_row->requirement_code,
					'requirement' => $get_row->batch_detail_requirement_name,
					'info_detail' => $get_row->requirement_description,
					'info'        => $get_row->cnt." ".$info
				);
				$no++;
			}
		}
		$this->session->set_userdata('status', $status);

		output_json($data);
	}

	public function export_excel() {

		$status   = $this->session->userdata('status');
		$get_data = $this->Reports_model->get_requirements_detail($status)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("PERSYARATAN")
							   ->setSubject("PERSYARATAN")
							   ->setDescription("PERSYARATAN")
							   ->setKeywords("PERSYARATAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PERSYARATAN");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$text_status = ($status == 1 ? "Paling banyak memenuhi persyaratan" : "Paling banyak tidak memenuhi persyaratan");

	    $excel->setActiveSheetIndex(0)->setCellValue('A3', "Status");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$text_status);
		
	    $excel->setActiveSheetIndex(0)->setCellValue('A5', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B5', "Kode");
	    $excel->setActiveSheetIndex(0)->setCellValue('C5', "Persyaratan");
	    $excel->setActiveSheetIndex(0)->setCellValue('D5', "Keterangan");
	    $excel->setActiveSheetIndex(0)->setCellValue('E5', "Info");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E5')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $row){ // Lakukan looping pada variabel row
			
			$info   = ($status == 1 ? "Peserta telah menyelesaikan syarat ini" : "Peserta belum menyelesaikan syarat ini");
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->requirement_code);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->batch_detail_requirement_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->requirement_description);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $row->cnt." ".$info);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PERSYARATAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PERSYARATAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
