<?php
/**
 * Report Sales Returns Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_sales_returns extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_returns_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Retur Penjualan';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_returns/index', $data);
	}

	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("sales_return_header_number ASC");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_return_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_return_detail_item_id'] = $item;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_return_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_return_header_date <='] = change_format_date($todate);
		}
		
		$where['sales_return_detail_total >'] = 0;

		$get_data = $this->Sales_returns_model->salesreturn_detail_advance($where, $order)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				// $ppn_status       = $get_row->sales_return_detail_ppn_status;
				// $ppn_status_color = '';

				// if($ppn_status == '2'){
				// 	$ppn_status_color = 'cl-success';
				// }
				// if($ppn_status == '3'){
				// 	$ppn_status_color = 'cl-warning';
				// }
				$data[] = array(
					'no'               => $no,
					'sales_number'     => $get_row->sales_return_header_number,
					'customer'         => $get_row->customer_name,
					'sales_date'       => change_format_date($get_row->sales_return_header_date, 'd/m/Y'),
					'item_name'        => $get_row->sales_return_detail_item_name,
					'lg_unit'          => ($get_row->sales_return_detail_large_unit_quantity  > 0 ? $get_row->sales_return_detail_large_unit : ''),
					'lg_unit_qty'      => ($get_row->sales_return_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_return_detail_large_unit_quantity) : ''),
					'lg_unit_prc'      => ($get_row->sales_return_detail_large_unit_quantity  > 0 ? number_format($get_row->sales_return_detail_large_unit_price) : ''),
					'md_unit'          => ($get_row->sales_return_detail_medium_unit_quantity > 0 ? $get_row->sales_return_detail_medium_unit : ''),
					'md_unit_qty'      => ($get_row->sales_return_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_return_detail_medium_unit_quantity) : ''),
					'md_unit_prc'      => ($get_row->sales_return_detail_medium_unit_quantity > 0 ? number_format($get_row->sales_return_detail_medium_unit_price) : ''),
					'sm_unit'          => ($get_row->sales_return_detail_small_unit_quantity  > 0 ? $get_row->sales_return_detail_small_unit : ''),
					'sm_unit_qty'      => ($get_row->sales_return_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_return_detail_small_unit_quantity) : ''),
					'sm_unit_prc'      => ($get_row->sales_return_detail_small_unit_quantity  > 0 ? number_format($get_row->sales_return_detail_small_unit_price) : ''),
					// 'ppn_status_color' => $ppn_status_color,
					'total'            => number_format($get_row->sales_return_detail_total),
				);
                $no++;
                
			}
		}
		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		output_json($data);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("sales_return_header_number ASC");
		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_return_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_return_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_return_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_return_header_date <='] = change_format_date($todate);
		}

		$where['sales_return_detail_total >'] = 0;

		$get_data = $this->Sales_returns_model->salesreturn_detail_advance($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("RETUR PENJUALAN")
							   ->setSubject("RETUR PENJUALAN")
							   ->setDescription("RETUR PENJUALAN")
							   ->setKeywords("RETUR PENJUALAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Retur Penjualan");
	    $excel->getActiveSheet()->mergeCells('A1:N1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);

	    $excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');

		$excel->getActiveSheet()->mergeCells('E7:G7');
		$excel->getActiveSheet()->mergeCells('H7:J7');
		$excel->getActiveSheet()->mergeCells('K7:M7');

		$excel->getActiveSheet()->mergeCells('N7:N8');

	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "Nomor Retur Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('F7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('E8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('F8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Harga");

		$excel->setActiveSheetIndex(0)->setCellValue('N7', "Total Harga");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E7:G7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H7:J7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('K7:M7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('N7:N8')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
		
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->sales_return_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->sales_return_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->sales_return_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($get_row->sales_return_detail_large_unit_quantity  > 0 ? $get_row->sales_return_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, ($get_row->sales_return_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_return_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_return_detail_large_unit_quantity  > 0 ? ($get_row->sales_return_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->sales_return_detail_medium_unit_quantity > 0 ? $get_row->sales_return_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->sales_return_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_return_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sales_return_detail_medium_unit_quantity > 0 ? ($get_row->sales_return_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sales_return_detail_small_unit_quantity  > 0 ? $get_row->sales_return_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, ($get_row->sales_return_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_return_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, ($get_row->sales_return_detail_small_unit_quantity  > 0 ? ($get_row->sales_return_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, ($get_row->sales_return_detail_total));

			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			// if($ppn_status == '3'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_warning);
			// }

			$excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("RETUR PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'RETURPENJUALAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
