<?php
/**
 * Units Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Units extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Units_model');
	}
	
	public function index() {
		$data['content_title'] = 'Satuan';

		$this->twiggy_display('adm/units/index', $data);
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Units_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'       => $no,
					'id'       => $get_row->unit_id,
					'name'     => $get_row->unit_name,
					'priority' => $get_row->unit_priority,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('unit_id' => $id);
			$get_data = $this->Units_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/units/edit', $data);
	}

	public function save() {
		// post
		$id       = $this->input->post('id');
		$name     = $this->input->post('name');
		$priority = $this->input->post('priority');
		$action   = $this->input->post('action');

		$data_save = array(
			'unit_name'     => $name,
			'unit_priority' => $priority
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Units_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Units_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Units_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$name  = $this->input->post('id');
		$where = array('unit_name' => $name);

		$check = $this->Units_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
