<?php
/**
 * Debts Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Debts_model extends Model {

	public function debt_autonumber($supp_code)
	{	
		$sql = $this->db;

		$sql->select('RIGHT(debt_headers.debt_header_number, 2) as serial_number', FALSE);
		$sql->where('MONTH(debt_header_date) = MONTH(CURRENT_DATE())');
		$sql->where('SUBSTR(debt_headers.debt_header_number, 4, 2) = "'.$supp_code.'"');
		$sql->order_by('debt_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('debt_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function debt_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('debt_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.debt_header_supplier_id', 'inner');
	    $sql->join('master_banks c', 'c.bank_id = a.debt_header_bank_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function debt_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('debt_details a');
	    $sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.debt_detail_purchase_order_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('debt_headers', $data);
		}

		return $this->db->insert('debt_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('debt_details', $data);
		}

		return $this->db->insert('debt_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('debt_header_id', $id);
		return $this->db->update('debt_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("debt_header_id", $id);
		return $this->db->delete("debt_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("debt_detail_header_id", $id);
		return $this->db->delete("debt_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("debt_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("debt_details");
	}

}

?>
