<?php
/**
 * Report Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Reports_model extends Model {

	public function get_special_price($select='*', $where='', $order='', $group='')
	{
		$sql = $this->db;

		$sql->select($select);
	    $sql->from('master_special_prices a');
	    $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'inner');
	    $sql->join('master_items c', 'c.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_poheader($select='*', $where='', $order='', $group='')
	{
    	$sql = $this->db;

		$sql->select($select);
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_soheader($select='*', $where='', $order='', $group='')
	{
    	$sql = $this->db;

		$sql->select($select);
		$sql->from('sales_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_profitByDate($date1, $date2, $status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.sales_order_detail_ppn_status = '".$status."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}else{
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}

		return $this->db->query($sql);
	}

	public function get_profitByItem($date1, $date2, $status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.printed_date as sales_date,
				c.sales_order_detail_item_id,
				c.sales_order_detail_item_name,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.sales_order_detail_ppn_status = '".$status."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date, c.sales_order_detail_item_id;
			";
		}else{
			$sql = "
			SELECT
				b.printed_date as sales_date,
				c.sales_order_detail_item_id,
				c.sales_order_detail_item_name,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date, c.sales_order_detail_item_id;
			";
		}

		return $this->db->query($sql);
	}

}

?>
