<?php
/**
 * Visit Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Visit_model extends Model {

	public function visit_autonumber($sales_code)
	{	
		$sql = $this->db;

		$sql->select('RIGHT(visit_headers.header_number, 2) as serial_number', FALSE);
		$sql->where('MONTH(header_date) = MONTH(CURRENT_DATE())');
		$sql->where('SUBSTR(visit_headers.header_number, 4, 2) = "'.$sales_code.'"');
		$sql->order_by('header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('visit_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function visit_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('visit_headers a');
	    $sql->join('master_sales b', 'b.sales_id = a.sales_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function visit_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, a.customer_id as customer_id');
	    $sql->from('visit_details a');
	    $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'left');
		$sql->join(
            'master_group_customers c',
            'c.group_customer_id = b.group_customer_id',
            'left'
        );

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('visit_headers', $data);
		}

		return $this->db->insert('visit_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('visit_details', $data);
		}

		return $this->db->insert('visit_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('header_id', $id);
		return $this->db->update('visit_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("visit_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("visit_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("visit_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("visit_details");
	}

}

?>
