/**
 * Javascript User
 *
 * @author Hikmahtiar <hikmahtiar.cool@gmail.com>
 */
window.USER = (function($) {

    // Start User
    var renderCheckbox = function(data, type, full, meta) {
        return '<input class="check-sub-user" type="checkbox" value="'+full['id']+'">';
    }

    var renderEdit = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/user/edit/' + full['id'];
        return '<a class="user-edit" href="'+url+'" data-toggle="tooltip" data-placement="top" title="Klik untuk Edit">'+data+'</a>';
    }

    var renderRoles = function(data, type, full, meta) {
    	var status = "";
    		if (full['role'] == 0) {
    		status += "<label class='label label-success'>Super Admin</label>";
			}else if (full['role'] == 1){
			status += "<label class='label label-primary'>Admin</label>";
			}else if (full['role'] == 2){
			status += "<label class='label label-default'>Penerimaan Pool</label>";
			}else if (full['role'] == 3){
			status += "<label class='label label-warning'>Penerimaan Site</label>";
			}else if (full['role'] == 4){
			status += "<label class='label label-info'>Repair Maintenance</label>";
	    	}else{
	        status += "<label class='label label-danger'>Unregistered</label>";
      		}
    	return status;
	}
	
	var renderLokasi = function (data, type, full, meta) {
		var status = "";
		if (full['lokasiid'] == 0) {
			status += "Semua Lokasi";
		}else{
			status += full['lokasi'];
		}

		return status;
	}
    // End User

	return {

		// Start User
		elDatatable        : null,
		elVue              : '#vue-user',
		elForm             : '.user-form',
		elEdit             : '.user-edit',
		elTable            : '#user-table',
		elModal            : '.user-modal',
		elBtnDelete        : '.user-delete',
		elModalClose       : '.user-cancel',
		elSubCheckbox      : '.check-sub-user',
		elParentCheckbox   : '.check-all-user',
		elModalContent     : '.user-modal-content',
		urlDeleteData      : window.APP.siteUrl + 'adm/user/delete',
		urlRequestData     : window.APP.siteUrl + 'adm/user/get_data',
		// End User

		init: function() {
			var parentThis = this;
		},

		// User
		handleVue: function() {
			var parentThis = this;

			// Vue Js
			new Vue({
				el : parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods : {
					addRowType : function() {
						var vue = this;
					}
				},
				mounted : function() {
					parentThis.handleDataTable();
				}
			});

		},

		// User : handleDataTable
		handleDataTable: function() {
			var parentThis = this;

			// Datatable
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url : parentThis.urlRequestData
				},
				columns : [
					{
						data      : 'no',
						width     : '20',
						className : 'center',
						className : 'fit-width',
						render : renderCheckbox
					},
					{
						data    : 'username',
						className : 'fit-width',
						render  : renderEdit
					},
					{
						data : 'name',
						className : 'fit-width',
					},
					{
						data      : 'roles',
						className : 'fit-width',
						render    : renderRoles
					},
					{
						data: 'lokasi',
						className : 'fit-width',
						render: renderLokasi
					}
				],
				order: false,
                deferRender: true,
                initComplete: function() {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);
					parentThis.handleDelete();
            window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
          }
			});
		},

		// User : handleDelete
		handleDelete : function() {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function() {

				// item dari sub check box
				var items = $(parentThis.elTable).find('input[class="check-sub-user"]:checked');

	            var types = [];
	            for (var i=0; i<items.length;i++) {
	                types.push($(items[i]).val());
	            }

	            if(!types.length) {
	                // menampilkan sweet alert
        					swal({
        						title : 'Anda belum memilih data yangg akan dihapus',
        						text  : "",
        						timer : 2000,
        						type  : 'error',
        						showConfirmButton: false
        					});

	                return false;
	            } else {

                  // alert
                  swal({
                    title : "Apa Anda Yakin?",
                    text  : "Ingin menghapus data ini",
                    type  : "warning",
                    showCancelButton  : true,
                    cancelButtonColor : "#DD6B55",
                    cancelButtonText  : "Batal",
                    confirmButtonColor: "#DD4B39",
                    confirmButtonText : "Ya, Hapus!",
                    closeOnConfirm    : false
                    }, function(){

          						// jika yakin menghapus maka menjalankan ajax request hapus data
          						$.ajax({
          							type     : "POST",
          							dataType : 'json',
          							url      : parentThis.urlDeleteData,
          							data: {
          							    id   : types,
          							},
          							success: function(response) {
          								window.FORM.showNotification(response.message, response.status);
          								// reload datatable
          								parentThis.elDatatable.ajax.reload();
          							}
          		         });

					});
	      }
			});
		},

	}

})(jQuery);
