<?php
/**
 * Imports Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Invoice_numbers extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Logs_model');
	}
	
	public function index() {

		$data['content_title'] = 'Nomor Faktur';
		$data['msg_unit']      = $this->session->userdata('msg_unit');
		

		$this->twiggy_display('adm/invoice_numbers/index', $data);
		$this->session->unset_userdata('msg_unit');
	}

	public function generate_number() {
		
		$month = $this->input->post('month');
		$date_from  = $month.'-01';
		$date_to    = $month.'-31';

		$where = [];
		$data = [];

		if(isset($month) && $month != '')
		{
			$where['sales_order_header_date >='] = $date_from;
			$where['sales_order_header_date <='] = $date_to;
		}
		
		$get_data    = $this->Sales_orders_model->salesorder_header($where)->result();

		// echo json_encode($where);
		// die();
		$faktur_1 = 0;
		$faktur_2 = 0;
		$faktur_3 = 0;
		$prefix_date = change_format_date($date_from, 'Ym');
		foreach($get_data as $key => $row){

			$data[] = array(
				'sales_order_header_id' => $row->sales_order_header_id,
			);

			if($row->faktur_1 != "0"){
				$data[$key]['faktur_1'] = $prefix_date.sprintf("%04d", $faktur_1 + 1);
				$faktur_1++;
			}

			if($row->faktur_2 != "0"){
				$data[$key]['faktur_2'] = $prefix_date.sprintf("%04d", $faktur_2 + 1);
				$faktur_2++;
			}

			if($row->faktur_3 != "0"){
				$data[$key]['faktur_3'] = $prefix_date.sprintf("%04d", $faktur_3 + 1);
				$faktur_3++;
			}
		}

		$update = $this->Sales_orders_model->update_invoice_number_batch($data);

		// echo json_encode($data);
		// die();	
		if($update){
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}
		
        redirect('adm/invoice_numbers/');

	}

}

?>
