<?php
/**
 * Resets Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Resets extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Logs_model');

		$this->load->model('Purchase_orders_model');
		$this->load->model('Sales_orders_model');
		$this->load->model('Purchase_returns_model');
		$this->load->model('Sales_returns_model');
		$this->load->model('Stocks_model');
		$this->load->model('Resets_model');
	}

	public function index() {
		$data['content_title'] = 'Reset Data';

		$data['msg_compress'] = $this->session->userdata('msg_compress');
		$data['msg_clear']    = $this->session->userdata('msg_clear');

		$this->twiggy_display('adm/resets/index', $data);
		$this->session->unset_userdata('msg_compress');
		$this->session->unset_userdata('msg_clear');
	}

	public function compress_data() {

		$delete_1 = $this->Resets_model->delete_log_points();
		if($delete_1){
			$delete_2 = $this->Resets_model->delete_logs();
		}
		if($delete_2){
			$delete_3 = $this->Stocks_model->truncate_header();
		}
		if($delete_3){
			$delete_4 = $this->Stocks_model->truncate_detail();
		}
		if($delete_4){
			$delete_5 = $this->Purchase_orders_model->truncate_header();
		}
		if($delete_5){
			$delete_6 = $this->Purchase_orders_model->truncate_detail();
		}
		if($delete_6){
			$delete_7 = $this->Sales_orders_model->truncate_header();
		}
		if($delete_7){
			$delete_8 = $this->Sales_orders_model->truncate_detail();
		}
		if($delete_8){
			$delete_9 = $this->Sales_returns_model->truncate_header();
		}
		if($delete_9){
			$delete_10 = $this->Sales_returns_model->truncate_detail();
		}
		if($delete_10){
			$delete_11 = $this->Purchase_returns_model->truncate_header();
		}
		if($delete_11){
			$delete_12 = $this->Purchase_returns_model->truncate_detail();
		}

		if($delete_12){
			$update_log = $this->Resets_model->update_log();
		}
		
		$msg = '';
		if($update_log){
			$msg = true;
			$this->session->set_userdata('msg_compress', $msg);
		}

		redirect('adm/resets/');
	}
	
	public function clear_data() {
		$delete_log = $this->Logs_model->truncate();
		$po_header  = $this->Purchase_orders_model->truncate_header();
		$po_detail  = $this->Purchase_orders_model->truncate_detail();
		$so_header  = $this->Sales_orders_model->truncate_header();
		$so_detail  = $this->Sales_orders_model->truncate_detail();
		$pr_header  = $this->Purchase_returns_model->truncate_header();
		$pr_detail  = $this->Purchase_returns_model->truncate_detail();
		$sr_header  = $this->Sales_returns_model->truncate_header();
		$sr_detail  = $this->Sales_returns_model->truncate_detail();
		$st_header  = $this->Stocks_model->truncate_header();
		$st_detail  = $this->Stocks_model->truncate_detail();

		$msg = '';
		if($st_detail){
			$msg = true;
			$this->session->set_userdata('msg_clear', $msg);
		}

		redirect('adm/resets/');
	}

}

?>
