<?php
/**
 * Graduation Requirements Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Grad_requirements_model extends Model {
	
	public function certificatenumber_generator($prog)
	{	
		$sql = $this->db;

		$sql->select('LEFT(graduates.certificate_number, 4) as serial_number', FALSE);
		$sql->where('SUBSTR(certificate_number, 6, "'.strlen($prog).'") = "'.$prog.'"');
		$sql->order_by('certificate_number', 'DESC');    
		$sql->limit(1);    
		$query = $sql->get('graduates');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_graduated($batch_id='', $graduated=true)
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('graduates');

    	if ($batch_id != '') {
			$sql->where('batch_id', $batch_id);
		}

		if($graduated){
			$sql->where('status', 1);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_requirement_bybatchtrainee($batch_id, $trainee_id)
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('batch_details a');
	    $sql->join('master_requirements c', 'c.requirement_id = a.batch_detail_requirement_id', 'inner');

    	if ($batch_id != '' && $trainee_id != '') {
			$sql->where('batch_detail_header_id', $batch_id);
			$sql->where('batch_detail_trainee_id', $trainee_id);
		}

		$get = $sql->get();

		return $get;
	}

	public function gradreq_header($id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('batch_headers a');
	    $sql->join('program_headers b', 'b.program_header_id = a.batch_header_program_id', 'inner');

    	if ($id != '') {
			$sql->where('batch_header_id', $id);
		}

		$get = $sql->get();

		return $get;
	}

	public function batch_header($id="")
	{
		$sql = $this->db;

		$sql->select('
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
			)
			AS all_date,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
				AND meeting_date > CURDATE()
			)
			AS running,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
				AND meeting_date < CURDATE()
			)
			AS done,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				graduates g
				WHERE g.batch_id = a.batch_header_id
				AND g.program_id = b.program_header_id
			)
			AS total_trainee,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				graduates g
				WHERE g.batch_id = a.batch_header_id
				AND g.program_id = b.program_header_id
				AND status = 1
			)
			AS graduated,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				graduates g
				WHERE g.batch_id = a.batch_header_id
				AND g.program_id = b.program_header_id
				AND status = 0
			)
			AS ungraduated
		');

		$sql->from('batch_headers a');
		$sql->join('program_headers b', 'b.program_header_id = a.batch_header_program_id', 'inner');
		$sql->join('master_program_types c', 'c.program_type_id = b.program_header_type_id', 'inner');
		$sql->join('master_program_classes d', 'd.program_class_id = b.program_header_class_id', 'inner');
		$sql->join('master_program_accreditations e', 'e.program_accreditation_id = b.program_header_accreditation_id', 'left');
		// $sql->join('meeting_schedules d', 'd.batch_id = a.batch_header_id and d.program_id = b.program_header_id', 'inner');
		
		if ($id != '') {
			$sql->where('batch_header_id', $id);
		}
		$sql->order_by('batch_year desc, batch_number desc');
		$get = $sql->get();

		return $get;
	}

	public function batch_detail($id="")
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('batch_details a');
	    $sql->join('master_trainees b', 'b.trainee_id = a.batch_detail_trainee_id', 'inner');
	    $sql->join('master_companies c', 'c.company_id = b.trainee_company_id', 'inner');
	    // $sql->join('master_job_titles d', 'd.job_title_id = b.trainee_job_title_id', 'inner');
	    $sql->join('graduates e', 'e.batch_id = a.batch_detail_header_id and e.trainee_id = a.batch_detail_trainee_id', 'inner');

		if ($id != "") {
			$sql->where("batch_detail_header_id", $id);
		}

		$sql->group_by(array('batch_detail_trainee_id', 'batch_detail_header_id'));

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('batch_headers', $data);
		}

		return $this->db->insert('batch_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('batch_details', $data);
		}

		return $this->db->insert('batch_details', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("batch_header_id", $id);
		return $this->db->delete("batch_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("batch_detail_header_id", $id);
		return $this->db->delete("batch_details");
	}

	public function update_status_requirements($id, $data)
	{
		$this->db->where("batch_detail_id", $id);
		return $this->db->update("batch_details", $data);
	}

	public function update_status_graduates($where, $data)
	{
		$this->db->where($where);
		return $this->db->update("graduates", $data);
	}

	public function update_info_graduates($where, $data)
	{
		$this->db->where($where);
		return $this->db->update("graduates", $data);
	}

	public function check_status($batch_id='', $program_id='', $trainee_id='', $status='')
	{
		$sql = "
		SELECT *
				FROM
				batch_details
				WHERE
				batch_detail_header_id  = '".$batch_id."' AND
				batch_detail_program_id = '".$program_id."' AND
				batch_detail_trainee_id = '".$trainee_id."' AND
				status = '".$status."'
		";

		return $this->db->query($sql);
	}

	public function check_meeting_total($batch_id=""){
		$sql = $this->db;

		$sql->select('*');
		$sql->from('meeting_schedules');
		
		if ($batch_id != "") {
			$sql->where("batch_id", $batch_id);
		}

		$get = $sql->get();

		return $get;
	}

}

?>
