<?php
/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Resets_model extends Model {

	public function delete_log_points()
	{
		$sql = "
			DELETE FROM log_points
			WHERE log_point_id NOT IN (
				SELECT * FROM (
				SELECT MAX(log_point_id) FROM log_points 
				GROUP BY log_point_customer_id
			)  AS s_alias
			); 
		";

		return $this->db->query($sql);
	}

	public function delete_logs()
	{
		$sql = "
			DELETE FROM logs
			WHERE log_id NOT IN (
				SELECT * FROM (
				SELECT MAX(log_id) FROM logs 
				GROUP BY log_item_id
			)  AS s_alias
			); 
		";

		return $this->db->query($sql);
	}

	public function delete_stheader()
	{
		$sql = "
			DELETE FROM stock_headers
			WHERE 
				stock_header_id NOT IN (
				SELECT l.log_transaction_id
				FROM logs l where log_type = 'STO'
			);  
		";

		return $this->db->query($sql);
	}

	public function delete_stdetail()
	{
		$sql = "
			DELETE FROM stock_details
			WHERE
				stock_detail_header_id NOT IN (
				SELECT p.stock_header_id
				FROM stock_headers p
			);
		";

		return $this->db->query($sql);
	}

	public function delete_poheader()
	{
		$sql = "
			DELETE FROM purchase_order_headers
			WHERE status_paid = 1 AND 
				purchase_order_header_id NOT IN (
				SELECT l.log_transaction_id
				FROM logs l where log_type = 'BUY'
			);  
		";

		return $this->db->query($sql);
	}

	public function delete_podetail()
	{
		$sql = "
			DELETE FROM purchase_order_details
			WHERE
				purchase_order_detail_header_id NOT IN (
				SELECT p.purchase_order_header_id
				FROM purchase_order_headers p
			);
		";

		return $this->db->query($sql);
	}

	public function delete_soheader()
	{
		$sql = "
			DELETE FROM sales_order_headers
			WHERE status_paid = 1 AND 
				sales_order_header_id NOT IN (
				SELECT s.log_transaction_id
				FROM logs s where log_type = 'SELL'
			);  
		";

		return $this->db->query($sql);
	}

	public function delete_sodetail()
	{
		$sql = "
			DELETE FROM sales_order_details
			WHERE
				sales_order_detail_header_id NOT IN (
				SELECT s.sales_order_header_id
				FROM sales_order_headers s
			);
		";

		return $this->db->query($sql);
	}

	public function delete_srheader()
	{
		$sql = "
			DELETE FROM sales_return_headers
			WHERE
				sales_order_header_id NOT IN (
				SELECT s.sales_order_header_id
				FROM sales_order_headers s
			);  
		";

		return $this->db->query($sql);
	}

	public function delete_srdetail()
	{
		$sql = "
			DELETE FROM sales_return_details
			WHERE
				sales_return_detail_header_id NOT IN (
				SELECT s.sales_return_header_id
				FROM sales_return_headers s
			);
		";

		return $this->db->query($sql);
	}

	public function delete_prheader()
	{
		$sql = "
			DELETE FROM purchase_return_headers
			WHERE
				purchase_order_header_id NOT IN (
				SELECT p.purchase_order_header_id
				FROM purchase_order_headers p
			);  
		";

		return $this->db->query($sql);
	}

	public function delete_prdetail()
	{
		$sql = "
			DELETE FROM purchase_return_details
			WHERE
				purchase_return_detail_header_id NOT IN (
				SELECT s.purchase_return_header_id
				FROM purchase_return_headers s
			);
		";

		return $this->db->query($sql);
	}

	public function update_log()
	{
		$sql = "
			UPDATE logs
			INNER JOIN master_items ON logs.log_item_id = master_items.item_id
			SET 
			logs.log_large_unit_purchase_price = master_items.last_purchase_price_large_unit,
			logs.log_medium_unit_purchase_price = master_items.last_purchase_price_medium_unit,
			logs.log_small_unit_purchase_price = master_items.last_purchase_price_small_unit,
			logs.log_average_large_unit = master_items.last_purchase_price_large_unit,
			logs.log_average_medium_unit = master_items.last_purchase_price_medium_unit,
			logs.log_average_small_unit = master_items.last_purchase_price_small_unit,

			logs.log_total_stock_value = 
			if(master_items.last_purchase_price_small_unit = 0, 
			if(master_items.last_purchase_price_medium_unit = 0,
			(logs.log_total_stock * master_items.last_purchase_price_large_unit),
			(logs.log_total_stock * master_items.last_purchase_price_medium_unit)),
			(logs.log_total_stock * master_items.last_purchase_price_small_unit))
		";

		return $this->db->query($sql);
	}
}

?>
