<?php
/**
 * Wasted Stocks Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Wasted_stocks_model extends Model {

	public function wastedstock_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(wasted_stock_headers.wasted_stock_header_number, 4) as serial_number', FALSE);
		$sql->order_by('wasted_stock_header_number', 'DESC');    
		$sql->limit(1);    
		$query = $sql->get('wasted_stock_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function wastedstock_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('wasted_stock_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.wasted_stock_header_supplier_id', 'inner');
	    $sql->join('master_warehouses c', 'c.warehouse_id = a.wasted_stock_header_warehouse_id', 'inner');
	    $sql->join('master_branches d', 'd.branch_id = c.warehouse_branch_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function wastedstock_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('wasted_stock_details a');
	    $sql->join('master_materials b', 'b.material_id = a.wasted_stock_detail_material_id', 'inner');
	    $sql->join('master_units c', 'c.unit_id = a.wasted_stock_detail_unit_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('wasted_stock_headers', $data);
		}

		return $this->db->insert('wasted_stock_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('wasted_stock_details', $data);
		}

		return $this->db->insert('wasted_stock_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('wasted_stock_header_id', $id);
		return $this->db->update('wasted_stock_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("wasted_stock_header_id", $id);
		return $this->db->delete("wasted_stock_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("wasted_stock_detail_header_id", $id);
		return $this->db->delete("wasted_stock_details");
	}

}

?>
