/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

window.EMBED = (function ($) {
	return {

		initVue: null,
		elVue: '#embed-vue',
		elTable: "#embed-table",
		elClose: '.embed-close',

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/debts/get_data_embed',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					listData: [],
					a:'',
				},
				methods: {
					getDataEmbed: function (Event) {
                        var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
                        var id = $("#id").val();
                        var supplier = $("#supplier-select").val();
                        var value = $("#search").val();
						
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
                            data: {
								'id': id,
								'supplier': supplier,
                                'search': value
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								var listData = {};

								for (i = 0; i < items.length; i++) {
									var item = items[i];

									var discount       = 0;
									var discount_total = 0;
									var total          = item.total;

									var btncolor = 'btn-default';
									var btnicon = '';

									if (vue.checkValue_isExists(item.id, vue.a) == 'Exist') {
										btncolor = 'btn-success';
										btnicon = 'fa fa-check';
										index = editVueInit.detailData.map(function (item) {
											return item.id
										}).indexOf(item.id);

										discount       = editVueInit.detailData[index].discount;
										discount_total = editVueInit.detailData[index].discount_total;
										total          = editVueInit.detailData[index].total;
									}
									listData[i] = {
										'no'            : item.no,
										'id'            : item.id,
										'number'        : item.number,
										'date'          : item.date,
										'sub_total'     : item.sub_total,
										'paid_total'     : item.paid_total,
										'return_total'  : item.return_total,
										'discount'      : discount,
										'discount_total': discount_total,
										'total'         : total,
										'btncolor'      : btncolor,
										'btnicon'       : btnicon,
									};
								}
								vue.listData = listData;
							}
						});
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
							editVueInit.detailData.push({
								id            : row.id,
								number        : row.number,
								date          : row.date,
								sub_total     : row.sub_total,
								return_total  : row.return_total,
								discount      : row.discount,
								discount_total: row.discount_total,
								total         : row.total,
							});
							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						}
						
						vue.checkData_isExists();
					},

					handleCount: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var discount = 0;

						total_paid = (row.sub_total.replace(/[^\w\s]/gi, '') - row.return_total.replace(/[^\w\s]/gi, ''))
						discount   = (total_paid * row.discount) / 100;
						total      = (total_paid - discount);
						vue.$set(row, 'total', total.toLocaleString("en-US"));
						vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
							vue.$set(editVueInit.detailData[index], 'discount_total', discount.toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'total', total.toLocaleString("en-US"));
						}
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						const a = [];
						const objectArray = Object.entries(editVueInit.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();
					
				}
			});

		},
	}
})(jQuery);