/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elItem: '.select-item',
		elGroup: '.select-group',
		elStatus: '.select-status',
		elStock: '.select-stock',
		elDate: '.date-log',

		urlRequestData: window.APP.siteUrl + 'adm/report_stocks/get_data_detail_recap_warehouse',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					item_name: '',
					group_name: '',
					date_log: '',
					total: '',
					status_name: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_item   = $(that.elItem).val();
						var val_group  = $(that.elGroup).val();
						var val_date   = $(that.elDate).val();
						var val_status   = $(that.elStatus).val();
						var val_stock   = $(that.elStock).val();

						var text_item  = $(that.elItem + ' option:selected').text();
						var text_group = $(that.elGroup + ' option:selected').text();
						var text_status = $(that.elStatus + ' option:selected').text();

						vue.$set(vue, 'item_name', text_item);
						vue.$set(vue, 'group_name', text_group);
						vue.$set(vue, 'date_log', val_date);
						vue.$set(vue, 'status_name', val_status);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'item'    : val_item,
								'group'   : val_group,
								'date_log': val_date,
								'status': val_status,
								'stock': val_stock
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['data']);

								// var a = response['data'];
								// var b = a.sort(function(a, b){
								// 	if(a.item_name < b.item_name){ return -1; }
								// 	if(a.item_name > b.item_name){ return 1; }
								// 	return 0
								// });
								
								// console.log(a);
								// vue.$set(vue, 'detailData', a);

								// vue.$set(vue, 'total', response['total']);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_stocks/export_excel_recap';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);