<?php
/**
 * Customers Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Customers_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_customers a');
		$sql->join('master_group_customers b', 'b.group_customer_id = a.group_customer_id', 'left');
		$sql->order_by('customer_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_customers', $data);
	}

	public function update($id, $data) {
		$this->db->where('customer_id', $id);
		return $this->db->update('master_customers', $data);
	}

	public function delete($id) {
		$this->db->where('customer_id', $id);
		return $this->db->delete('master_customers');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_customers');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
