<?php
/**
 * Groups Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Groups_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('master_groups');
		$sql->order_by('group_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_child($where='') {
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_group_childs a');
		$sql->join('master_groups b', 'b.group_id = a.group_id', 'left');
		$sql->order_by('group_child_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_groups', $data);
	}

	public function save_child($data) {
		return $this->db->insert('master_group_childs', $data);
	}

	public function update($id, $data) {
		$this->db->where('group_id', $id);
		return $this->db->update('master_groups', $data);
	}

	public function update_child($id, $data) {
		$this->db->where('group_child_id', $id);
		return $this->db->update('master_group_childs', $data);
	}

	public function delete($id) {
		$this->db->where('group_id', $id);
		return $this->db->delete('master_groups');
	}

	public function delete_child_group($id) {
		$this->db->where('group_id', $id);
		return $this->db->delete('master_group_childs');
	}

	public function delete_child($id) {
		$this->db->where('group_child_id', $id);
		return $this->db->delete('master_group_childs');
	}

	public function check_id($table, $where) {
		$this->db->select("*");
		$this->db->from($table);
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
	

}

?>
