<?php
/**
 * Logs Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Logs_model extends Model {

	public function get_data($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('logs a');
	    $sql->join('master_items b', 'b.item_id = a.log_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, a.timestamp as tms_log');
	    $sql->from('logs a');
		$sql->join('master_items b', 'b.item_id = a.log_item_id', 'left');
		$sql->join('master_groups c', 'c.group_id = b.item_group_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, 
		a.timestamp as tms_log');
	    $sql->from('logs a');
	    $sql->join('master_items b', 'b.item_id = a.log_item_id', 'left');
		
		$sql->join('purchase_order_headers c', 'c.purchase_order_header_id = a.log_transaction_id AND a.log_type="BUY"', 'left');
	    $sql->join('sales_order_headers d', 'd.sales_order_header_id = a.log_transaction_id AND a.log_type="SELL"', 'left');
	    

		$sql->join('purchase_return_headers g', 'g.purchase_return_header_id = a.log_transaction_id AND a.log_type="R-BUY"', 'left');
		$sql->join('sales_return_headers h', 'h.sales_return_header_id = a.log_transaction_id AND a.log_type="R-SELL"', 'left');

		$sql->join('stock_headers i', 'i.stock_header_id = a.log_transaction_id AND a.log_type="STO"', 'left');

		
		$sql->join('master_suppliers e', 'e.supplier_id = c.purchase_order_header_supplier_id OR e.supplier_id = g.purchase_return_header_supplier_id', 'left');
		$sql->join('master_customers f', 'f.customer_id = d.sales_order_header_customer_id OR f.customer_id = h.sales_return_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_detail_recap($where='', $where_timestamp='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('logs a');
	    $sql->join('master_items b', 'b.item_id = a.log_item_id', 'left');
	    $sql->join('master_groups c', 'c.group_id = b.item_group_id', 'left');
	    $sql->join('(SELECT MAX(log_id) AS log_max_id FROM logs WHERE DATE(timestamp) <= "'.$where_timestamp.'" GROUP BY log_item_id ORDER BY log_id DESC) AS x', 'a.log_id = x.log_max_id');

		if ($where != '') {
			$sql->where($where);
		}

		$sql->order_by('item_name', 'ASC');

		$get = $sql->get();

		return $get;
	}

	public function get_data_last($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('logs a');
	    $sql->join('master_items b', 'b.item_id = a.log_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		$sql->order_by('a.timestamp', 'desc');
		$sql->limit(1);

		$get = $sql->get();

		return $get;
	}

	public function save($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('logs', $data);
		}

		return $this->db->insert('logs', $data);
	}

	public function update_item($where, $data) {
		$this->db->where($where);
		return $this->db->update('logs', $data);
	}

	public function delete($where) {
		$this->db->where($where);
		return $this->db->delete("logs");
	}

	public function truncate()
	{
		return $this->db->empty_table("logs");
	}

}

?>
