<?php
/**
 * Report Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Report_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select("
			d.student_id as student_id,
			d.deposit_number as number,
			d.deposit_date as date,
			d.deposit_amount as amount,
			'D' as type
		");
        $sql->from("deposit d");

		if ($where != '')
		{
			$sql->where($where);
		}

		$query1 = $sql->get_compiled_select();
		
		$sql->select("
			w.student_id as student_id,
			x.withdraw_header_number as number,
			x.withdraw_header_date as date,
			(w.withdraw_detail_amount * -1) as amount,
			'W' as type
		");

        $sql->from('withdraw_detail w');
		$sql->join('withdraw_header x', 'x.withdraw_header_id = w.withdraw_header_id', 'inner');

		if ($where != '')
		{
			$sql->where($where);
		}

		$query2 = $sql->get_compiled_select();

		$get = $sql->query($query1 . ' UNION ' . $query2 . 'ORDER BY date ASC');

		return $get;
	}


	public function cs_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('t_cs_detail a');
	    $sql->join('m_cs c', 'c.cs_id = a.cs_detail_item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

}

?>
