<?php
/**
 * Sales Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class sales_returns_model extends Model {

	public function salesreturn_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('sales_return_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.sales_return_header_customer_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesreturn_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('sales_return_details a');
	    $sql->join('sales_return_headers b', 'b.sales_return_header_id = a.sales_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.sales_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesreturn_detail_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('sales_return_details a');
	    $sql->join('sales_return_headers b', 'b.sales_return_header_id = a.sales_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.sales_return_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.sales_return_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesreturn_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, SUM(a.sales_return_detail_total) as total_return');
	    $sql->from('sales_return_details a');
	    $sql->join('sales_return_headers b', 'b.sales_return_header_id = a.sales_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.sales_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('sales_return_headers', $data);
		}

		return $this->db->insert('sales_return_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('sales_return_details', $data);
		}

		return $this->db->insert('sales_return_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('sales_return_header_id', $id);
		return $this->db->update('sales_return_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("sales_return_header_id", $id);
		return $this->db->delete("sales_return_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("sales_return_detail_header_id", $id);
		return $this->db->delete("sales_return_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("sales_return_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("sales_return_details");
	}

}

?>
