<?php
/**
 * Student Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Student_model extends Model {

	public function get_data($where="") {
		$sql = $this->db;

		$sql->select("*");
        $sql->from("master_student a");
		$sql->join("master_grade b", "b.grade_id = a.grade_id", "inner");

		$sql->order_by('student_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_student', $data);
	}

	public function update($id, $data) {
		$this->db->where('student_id', $id);
		return $this->db->update('master_student', $data);
	}

	public function delete($id) {
		$this->db->where('student_id', $id);
		return $this->db->delete('master_student');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_student');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
