<?php
/**
 * Withdraw Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Withdraw_model extends Model {

	public function withdraw_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(withdraw_header.withdraw_header_number, 2) as serial_number', FALSE);
		$sql->where('MONTH(withdraw_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('withdraw_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('withdraw_header');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function withdraw_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('withdraw_header a');
	    $sql->join('master_grade b', 'b.grade_id = a.grade_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function withdraw_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('withdraw_detail a');
	    $sql->join('withdraw_header b', 'b.withdraw_header_id = a.withdraw_header_id', 'inner');
	    $sql->join('master_student c', 'c.student_id = a.student_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('withdraw_header', $data);
		}

		return $this->db->insert('withdraw_header', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('withdraw_detail', $data);
		}

		return $this->db->insert('withdraw_detail', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('withdraw_header_id', $id);
		return $this->db->update('withdraw_header', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("withdraw_header_id", $id);
		return $this->db->delete("withdraw_header");
	}

	public function delete_detail($id)
	{
		$this->db->where("withdraw_header_id", $id);
		return $this->db->delete("withdraw_detail");
	}

}

?>
