/**
 * Javascript Supplier
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.SUPPLIER = (function($) {

    // Start Supplier
    var renderCheckboxSupplier = function(data, type, full, meta) {
        return '<input class="check-sub-supplier" type="checkbox" value="'+full['id']+'">';
    }

    var renderEditSupplier = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/supplier/edit/' + full['id'];
        return '<a class="supplier-edit" href="'+url+'" data-toggle="tooltip" data-placement="top" title="Click For Edit">'+data+'</a>';
    }
    // End Supplier

	return {

		// Start Supplier
		elDatatableSupplier      : null,
		elVueSupplier            : '#vue-supplier',
		elFormSupplier           : '.supplier-form',
		elEditSupplier           : '.supplier-edit',
		elTableSupplier          : '#supplier-table',
		elModalSupplier          : '.supplier-modal',
		elBtnDeleteSupplier      : '.supplier-delete',
		elModalCloseSupplier     : '.supplier-cancel',
		elSubCheckboxSupplier    : '.check-sub-supplier',
		elParentCheckboxSupplier : '.check-all-supplier',
		elModalContentSupplier   : '.supplier-modal-content',
		urlDeleteDataSupplier    : window.APP.siteUrl + 'adm/supplier/delete',
		urlRequestDataSupplier   : window.APP.siteUrl + 'adm/supplier/get_data',
		// End Supplier

		init: function() {
			var parentThis = this;
		},

		// Supplier
		handleVueSupplier: function() {
			var parentThis = this;

			// Vue Js
			new Vue({
				el : parentThis.elVueSupplier,
				delimiters: ['<%', '%>'],
				methods : {
					addRowType : function() {
						var vue = this;
					}
				},
				mounted : function() {
					parentThis.handleDataTableSupplier();
				}
			});

		},

		// Supplier : handleDataTableSupplier
		handleDataTableSupplier: function() {
			var parentThis = this;

			// Datatable
			parentThis.elDatatableSupplier = $(parentThis.elTableSupplier).DataTable({
				ajax: {
					url : parentThis.urlRequestDataSupplier
				},
				columns : [
					{
						data      : 'no',
						className : 'center',
						render : renderCheckboxSupplier,
            className : 'fit-width',
					},
					{
						data   : 'kode',
						render : renderEditSupplier,
            className : 'fit-width',
					},
          {
						data   : 'nama',
            className : 'fit-width',
					},
          {
						data   : 'alamat',
            className : 'fit-width',
					},
          {
						data   : 'telp',
            className : 'fit-width',
					},
          {
						data   : 'fax',
            className : 'fit-width',
					},
          {
						data   : 'kontak',
            className : 'fit-width',
					},
          {
						data   : 'kota',
            className : 'fit-width',
					},
          {
						data   : 'provinsi',
            className : 'fit-width',
					},
          {
            data   : 'email',
            className : 'fit-width',
          },
				],
				order: false,
                deferRender: true,
                initComplete: function() {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elFormSupplier,
						parentThis.elEditSupplier,
						parentThis.elModalSupplier,
						parentThis.elModalContentSupplier,
						parentThis.elModalCloseSupplier,
						parentThis.elDatatableSupplier
					);
					parentThis.handleDeleteSupplier();
          	window.INPUT.handleCheckboxAll(parentThis.elParentCheckboxSupplier, parentThis.elSubCheckboxSupplier);
          }
			});
		},

		// Supplier : handleDeleteSupplier
		handleDeleteSupplier : function() {
			var parentThis = this;

			$(parentThis.elBtnDeleteSupplier).click(function() {

				// Supplier dari sub check box
				var Suppliers = $(parentThis.elTableSupplier).find('input[class="check-sub-supplier"]:checked');

	            var types = [];
	            for (var i=0; i<Suppliers.length;i++) {
	                types.push($(Suppliers[i]).val());
	            }

	            if(!types.length) {
	              // menampilkan sweet alert
        				swal({
        					title  : 'Anda belum memilih data yang akan dihapus.',
        					text   : "",
        					timer  : 2000,
      						type   : 'error',
        					showConfirmButton: false
      					});
        	         return false;

              } else {

                // alert
                swal({
                  title : "Apa Anda Yakin?",
                  text  : "Ingin menghapus data ini",
                  type  : "warning",
                  showCancelButton  : true,
                  cancelButtonColor : "#DD6B55",
                  cancelButtonText  : "Batal",
                  confirmButtonColor: "#DD4B39",
                  confirmButtonText : "Ya, Hapus!",
                  closeOnConfirm    : false
                  }, function(){

      						// jika yakin menghapus maka menjalankan ajax request hapus data
      						$.ajax({
      							type     : "POST",
      							dataType : 'json',
      							url      : parentThis.urlDeleteDataSupplier,
      							data: {
      							    id   : types,
      							},
      							success: function(response) {
      								window.FORM.showNotification(response.message, response.status);
      								// reload datatable
      								parentThis.elDatatableSupplier.ajax.reload();
      							}
      		        });

					});
	       }
			});
		},

	}

})(jQuery);
