/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/withdraw/print_out/',
        urlList: window.APP.siteUrl + 'adm/withdraw/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/withdraw/get_data_detail',
        urlRequestStudentData: window.APP.siteUrl + 'adm/withdraw/get_data_student',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					paymentMethod: ''
				},
				methods: {
					detailAdd: function () {
						// show modal
						$(that.elModal).modal("show");
						$.ajax({
							url: that.urlList,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								// var ii = $('.check-sub');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
                    },

					handleStudentData: function (id) {
                    	var vue = this;

                    	$.ajax({
                    		url: that.urlRequestStudentData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
                    },

					getRow: function (index) {
						var vue = this;

						if(vue.detailData[index].selected_row == ''){
							vue.$set(vue.detailData[index], 'selected_row', 'bg-selected');
							vue.$set(vue.detailData[index], 'selected_icon', 'far fa-check-circle');
						}else{
							vue.$set(vue.detailData[index], 'selected_row', '');
							vue.$set(vue.detailData[index], 'selected_icon', '');
						}
						
					},

					handlePayment: function () {
						var vue = this;

						var previousValue;
						$("#grade-select").on('focus', function (e) {
							previousValue = this.value;
						}).change(function () {
							var storedPreviousValue = previousValue;
							
							vue.handleStudentData(this.value);

							if (vue.detailData.length > 0) {

								Swal.fire({
									title: 'Anda yakin ingin mengganti Supplier?',
									text: "Data item akan direset",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										vue.detailData.splice(0, vue.detailData.length);
										vue.handleStudentData(this.value);
									} else if (result.dismiss == 'cancel') {
										
										if (previousValue != undefined) {
											$("#grade-select").val(storedPreviousValue).trigger('change.select2');
										}
										vue.handleStudentData(this.value);
										previousValue = storedPreviousValue;
									}
								})

							}

							previousValue = this.value;
						
						});
					},

					handleNumber: function () {
						var vue = this;

						var previousValue;
						$("#supplier-select").on('focus', function (e) {
							previousValue = this.value;
						}).change(function () {
							var storedPreviousValue = previousValue;
							
							vue.handleServiceNumber(this.value);

							if (vue.detailData.length > 0) {

								Swal.fire({
									title: 'Anda yakin ingin mengganti Supplier?',
									text: "Data item akan direset",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										vue.detailData.splice(0, vue.detailData.length);
										vue.handleServiceNumber(this.value);
									} else if (result.dismiss == 'cancel') {
										
										if (previousValue != undefined) {
											$("#supplier-select").val(storedPreviousValue).trigger('change.select2');
										}
										vue.handleServiceNumber(this.value);
										previousValue = storedPreviousValue;
									}
								})

							}

							previousValue = this.value;
						
						});
					},

					countTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							if(items[i].selected_row != ''){
								totalAmmount += parseFloat(items[i].student_limit.replace(/,/g, ''));
							}
						}

						return totalAmmount.toLocaleString("en-US");
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 1);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},

					handleForm2: function () {
						var vue = this;
			
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
			
						$(that.elForm).ajaxForm({
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
			
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$(that.elVue).unblock();
									return false;
								}
							},
							data: {
								vuedata: vue.detailData
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();
			
								window.FORM.showNotification(response.message, response.status);
			
								if (response.status == "success") {
									if(response.btn_action == "finish"){
										setTimeout(function () {
											window.location.href = that.urlPrintOut +response.id
										}, 1500);
									}else{
										setTimeout(function () {
											window.location.href = that.urlIndex
										}, 1500);
									}
								}
			
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
				
                    // if(id != 'new'){
					// 	vue.handleData();
					// }
					vue.handlePayment();

					vue.handleNumber();
					vue.handleCheckbox();
					
					setTimeout(function () {
						
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
						var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						window.INPUT.handleSelect2();
					}, 500);
				}
			});

		},

		// form
		
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);